/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx__driver_interface.c,v 1.46 2006/12/12 01:47:13 patrick Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__driver_interface.h"
#include "mx__fops.h"
#include "mx_io_impl.h"

MX_FUNC(mx_return_t)
mx__crashdump(mx_endpt_handle_t handle, mx_crashdump_t *p)
{
  return mx__ioctl(handle, MX_CRASHDUMP, p, sizeof (*p));
}

/* Number of boards in the host. */
MX_FUNC(mx_return_t)
mx__get_instance_count(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_INSTANCE_COUNT, p, sizeof (*p));
}

/* Maximum number of boards in the host. */
MX_FUNC(mx_return_t)
mx__get_max_instance(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_MAX_INSTANCE, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_nic_id(mx_endpt_handle_t handle, mx_get_nic_id_t *p)
{
  return mx__ioctl(handle, MX_GET_NIC_ID, p, sizeof (*p));
}

/* Number of mcp handles (outstanding requests). */
MX_FUNC(mx_return_t)
mx__get_num_handles(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_MAX_SEND_HANDLES, p, sizeof (*p));
}

/* Number of mcp handles (outstanding requests). */
MX_FUNC(mx_return_t)
mx__get_max_rdma_windows(mx_endpt_handle_t handle, int32_t *p)
{
  return mx__ioctl(handle, MX_GET_MAX_RDMA_WINDOWS, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_copyblocks(mx_endpt_handle_t handle, mx_get_copyblock_t *p)
{
  return mx__ioctl(handle, MX_GET_COPYBLOCKS, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__set_endpoint(mx_endpt_handle_t handle, mx_set_endpt_t *p)
{
  return mx__ioctl(handle, MX_SET_ENDPOINT, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_counters(mx_endpt_handle_t handle, uint32_t board_number, uint32_t counters[1024])
{
  counters[0] = board_number;
  return mx__ioctl(handle, MX_GET_COUNTERS, counters, sizeof (counters));
}

#if MX_DRIVER_API_MAGIC >= 0x500
MX_FUNC(mx_return_t)
mx__get_some_counters(mx_endpt_handle_t handle, mx_get_some_counters_t *p)
{
  return mx__ioctl(handle, MX_GET_SOME_COUNTERS, p, sizeof (*p));
}
#endif

MX_FUNC(mx_return_t)
mx__clear_counters(mx_endpt_handle_t handle, uint32_t board_number)
{
  return mx__ioctl(handle, MX_CLEAR_COUNTERS, &board_number,
		   sizeof (board_number));
}

MX_FUNC(mx_return_t)
mx__register(mx_endpt_handle_t handle, mx_reg_t *p)
{
  return mx__ioctl(handle, MX_REGISTER, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__deregister(mx_endpt_handle_t handle, uint32_t mcp_handle)
{
  return mx__ioctl(handle, MX_DEREGISTER, &mcp_handle, sizeof (mcp_handle));
}

MX_FUNC(mx_return_t)
mx__get_counters_strings(mx_endpt_handle_t handle, uint32_t board_number,
			 mx_get_counters_strings_t *p)
{
  p->board_number = board_number;
  return mx__ioctl(handle, MX_GET_COUNTERS_STRINGS, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_logging_strings(mx_endpt_handle_t handle, uint32_t board_number,
			mx_get_logging_strings_t *p)
{
  p->board_number = board_number;
  return mx__ioctl(handle, MX_GET_LOGGING_STRINGS, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__nic_id_to_board_num(mx_endpt_handle_t handle, mx_nic_id_to_board_num_t *p)
{
  return mx__ioctl(handle, MX_NIC_ID_TO_BOARD_NUM, p, sizeof (*p));
}

/* Number of physical ports on the card. */
MX_FUNC(mx_return_t)
mx__get_num_ports(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_NUM_PORTS, p, sizeof (*p));
}

/* Number of software endpoints. */
MX_FUNC(mx_return_t)
mx__get_max_endpoints(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_MAX_ENDPOINTS, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_logging(mx_endpt_handle_t handle, mx_get_logging_t *p)
{
  return mx__ioctl(handle, MX_GET_LOGGING, p, sizeof (*p));
}

/* Macaddr to local peer index. */
MX_FUNC(mx_return_t)
mx__nic_id_to_peer_index(mx_endpt_handle_t handle, mx_lookup_peer_t *p)
{
  return mx__ioctl(handle, MX_NIC_ID_TO_PEER_INDEX, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_mapper_msgbuf_size(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_MAPPER_MSGBUF_SIZE, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_mapper_mapbuf_size(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_MAPPER_MAPBUF_SIZE, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_mapper_msgbuf(mx_endpt_handle_t handle, char *p)
{
  return mx__ioctl(handle, MX_GET_MAPPER_MSGBUF, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_mapper_mapbuf(mx_endpt_handle_t handle, char *p)
{
  return mx__ioctl(handle, MX_GET_MAPPER_MAPBUF, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_peer_format(mx_endpt_handle_t handle, mx_get_peer_format_t *p)
{
  return mx__ioctl(handle, MX_GET_PEER_FORMAT, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_route_size(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_ROUTE_SIZE, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_peer_table(mx_endpt_handle_t handle, char *p)
{
  return mx__ioctl(handle, MX_GET_PEER_TABLE, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_route_table(mx_endpt_handle_t handle, mx_get_route_table_t *p)
{
  return mx__ioctl(handle, MX_GET_ROUTE_TABLE, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_max_peers(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_MAX_PEERS, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__pause_mapper(mx_endpt_handle_t handle, uint32_t board_number)
{
  return mx__ioctl(handle, MX_PAUSE_MAPPER, &board_number,
		   sizeof (board_number));
}

MX_FUNC(mx_return_t)
mx__resume_mapper(mx_endpt_handle_t handle, uint32_t board_number)
{
  return mx__ioctl(handle, MX_RESUME_MAPPER, &board_number,
		   sizeof (board_number));
}

MX_FUNC(mx_return_t)
mx__raw_get_params(mx_endpt_handle_t handle, mx_raw_params_t *p)
{
  return mx__ioctl(handle, MX_RAW_GET_PARAMS, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__raw_clear_routes(mx_endpt_handle_t handle, mx_set_route_t *p)
{
  return mx__ioctl(handle, MX_RAW_CLEAR_ROUTES, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_serial_number(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_SERIAL_NUMBER, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_opener(mx_endpt_handle_t handle, mx_get_opener_t *p)
{
  return mx__ioctl(handle, MX_GET_OPENER, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__hostname_to_nic_id(mx_endpt_handle_t handle, mx_nic_id_hostname_t *p)
{
  return mx__ioctl(handle, MX_HOSTNAME_TO_NIC_ID, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__nic_id_to_hostname(mx_endpt_handle_t handle, mx_nic_id_hostname_t *p)
{
  return mx__ioctl(handle, MX_NIC_ID_TO_HOSTNAME, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__clear_peer_names(mx_endpt_handle_t handle)
{
  return mx__ioctl(handle, MX_CLEAR_PEER_NAMES, 0, 0);
}

MX_FUNC(mx_return_t)
mx__set_host_name(mx_endpt_handle_t handle, mx_set_hostname_t *p)
{
  return mx__ioctl(handle, MX_SET_HOSTNAME, p, sizeof(*p));
}
MX_FUNC(mx_return_t)
mx__get_cacheline_size(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_CACHELINE_SIZE, p, sizeof (*p));
}
MX_FUNC(mx_return_t)
mx__get_small_message_threshold(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_SMALL_MESSAGE_THRESHOLD, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_medium_message_threshold(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_MEDIUM_MESSAGE_THRESHOLD, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__set_route(mx_endpt_handle_t handle, mx_set_route_t *p)
{
  return mx__ioctl(handle, MX_SET_ROUTE, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__set_route_begin(mx_endpt_handle_t handle, uint32_t board_number)
{
  return mx__ioctl(handle, MX_SET_ROUTE_BEGIN, &board_number, sizeof(board_number));
}

MX_FUNC(mx_return_t)
mx__set_route_end(mx_endpt_handle_t handle, uint32_t board_number)
{
  return mx__ioctl(handle, MX_SET_ROUTE_END, &board_number, sizeof(board_number));
}

MX_FUNC(mx_return_t)
mx__wait(mx_endpt_handle_t handle, mx_wait_t *p)
{
  return mx__ioctl(handle, MX_WAIT, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__app_wait(mx_endpt_handle_t handle, mx_wait_t *p)
{
  return mx__ioctl(handle, MX_APP_WAIT, p, sizeof (*p));
}

#if MX_DRIVER_API_MAGIC >= 0x500
MX_FUNC(mx_return_t)
mx__wait_for_recovery(mx_endpt_handle_t handle, uint32_t *status)
{
  return mx__ioctl(handle, MX_WAIT_FOR_RECOVERY, status, sizeof (*status));
}
#endif

MX_FUNC(mx_return_t)
mx__clear_wait(mx_endpt_handle_t handle)
{
  return mx__ioctl(handle, MX_CLEAR_WAIT, 0, 0);
}

MX_FUNC(mx_return_t)
mx__wake(mx_endpt_handle_t handle)
{
  return mx__ioctl(handle, MX_WAKE, 0, 0);
}

MX_FUNC(mx_return_t)
mx__app_wake(mx_endpt_handle_t handle)
{
  return mx__ioctl(handle, MX_APP_WAKE, 0, 0);
}

MX_FUNC(mx_return_t)
mx__get_irq_counters(mx_endpt_handle_t handle, uint32_t board_number, mx_irq_counters_t *irq)
{
  irq->board_number = board_number;
  return mx__ioctl(handle, MX_GET_IRQ_COUNTERS, irq, sizeof(*irq));
}

MX_FUNC(mx_return_t)
mx__run_dmabench(mx_endpt_handle_t handle, mx_dmabench_t *b)
{
  return mx__ioctl(handle, MX_RUN_DMABENCH, b, sizeof(*b));
}

MX_FUNC(mx_return_t)
mx__get_board_status(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_BOARD_STATUS, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_cpu_freq(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_CPU_FREQ, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_pci_freq(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_PCI_FREQ, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__set_raw(mx_endpt_handle_t handle)
{
  return mx__ioctl(handle, MX_SET_RAW, 0, 0);
}

MX_FUNC(mx_return_t)
mx__raw_send(mx_endpt_handle_t handle, mx_raw_send_t *p)
{
  return mx__ioctl(handle, MX_RAW_SEND, p, sizeof (*p));
}

#if MX_OS_WINNT
MX_FUNC(mx_return_t)
mx__raw_ticks(mx_endpt_handle_t handle, uint32_t *p)
{
  return MX_FAILURE;
}
#endif

MX_FUNC(mx_return_t)
mx__raw_get_next_event(mx_endpt_handle_t handle, mx_raw_next_event_t *p)
{
  return mx__ioctl(handle, MX_RAW_GET_NEXT_EVENT, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__set_mapper_state(mx_endpt_handle_t handle, mx_mapper_state_t *p)
{
  return mx__ioctl(handle, MX_SET_MAPPER_STATE, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_mapper_state(mx_endpt_handle_t handle, mx_mapper_state_t *p)
{
  return mx__ioctl(handle, MX_GET_MAPPER_STATE, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_intr_coal(mx_endpt_handle_t handle, mx_intr_coal_t *p)
{
 return mx__ioctl(handle, MX_GET_INTR_COAL, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__set_intr_coal(mx_endpt_handle_t handle, mx_intr_coal_t *p)
{
 return mx__ioctl(handle, MX_SET_INTR_COAL, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__recover_endpoint(mx_endpt_handle_t handle)
{
  return mx__ioctl(handle, MX_RECOVER_ENDPOINT, 0, 0);
}

MX_FUNC(mx_return_t)
mx__remove_peer(mx_endpt_handle_t handle, mx_raw_destination_t *p)
{
  return mx__ioctl(handle, MX_REMOVE_PEER, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_link_state(mx_endpt_handle_t handle, uint32_t *p)
{
  return mx__ioctl(handle, MX_GET_LINK_STATE, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__peer_index_to_nic_id(mx_endpt_handle_t handle, mx_lookup_peer_t *p)
{
  return mx__ioctl(handle, MX_PEER_INDEX_TO_NIC_ID, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__direct_get(mx_endpt_handle_t handle, mx_direct_get_t *p)
{
  return mx__ioctl(handle, MX_DIRECT_GET, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__direct_getv(mx_endpt_handle_t handle, mx_direct_getv_t *p)
{
  return mx__ioctl(handle, MX_DIRECT_GETV, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__wake_endpoint(mx_endpt_handle_t handle, mx_wake_endpt_t *p)
{
  return mx__ioctl(handle, MX_WAKE_ENDPOINT, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_product_code(mx_endpt_handle_t handle, mx_get_eeprom_string_t *p)
{
  return mx__ioctl(handle, MX_GET_PRODUCT_CODE, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_part_number(mx_endpt_handle_t handle, mx_get_eeprom_string_t *p)
{
  return mx__ioctl(handle, MX_GET_PART_NUMBER, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_version(mx_endpt_handle_t handle, mx_get_version_t *p)
{
  return mx__ioctl(handle, MX_GET_VERSION, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_sram_size(mx_endpt_handle_t handle, mx_get_board_val_t *p)
{
  return mx__ioctl(handle, MX_GET_SRAM_SIZE, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_dump_reg_count(mx_endpt_handle_t handle, mx_get_board_val_t *p)
{
  return mx__ioctl(handle, MX_GET_DUMP_REG_COUNT, p, sizeof (*p));
}

MX_FUNC(mx_return_t)
mx__get_board_type(mx_endpt_handle_t handle, mx_get_board_val_t *p)
{
  return mx__ioctl(handle, MX_GET_BOARD_TYPE, p, sizeof (*p));
}

MX_FUNC(mx_return_t) mx__write_pio_req(mx_endpt_handle_t handle, mx_write_pio_req_t *p)
{
  return mx__ioctl(handle, MX_WRITE_PIO_REQ, p, sizeof (*p));
}

MX_FUNC(mx_return_t) mx__arm_timer(mx_endpt_handle_t handle, uint32_t ms)
{
  return mx__ioctl(handle, MX_ARM_TIMER, &ms, sizeof (ms));
}

#if MX_DRIVER_API_MAGIC >= 0x500
MX_FUNC(mx_return_t) mx__raw_set_nic_reply_info(mx_endpt_handle_t handle, mx_raw_set_nic_reply_info_t *p)
{
  return mx__ioctl(handle, MX_RAW_SET_NIC_REPLY_INFO, p, sizeof (*p));
}
#endif

MX_FUNC(mx_return_t) mx__pci_cfg_read(mx_endpt_handle_t handle, mx_pci_cfg_t *p)
{
  return mx__ioctl(handle, MX_PCI_CFG_READ, p, sizeof (*p));
}

MX_FUNC(mx_return_t) mx__pci_cfg_write(mx_endpt_handle_t handle, mx_pci_cfg_t *p)
{
  return mx__ioctl(handle, MX_PCI_CFG_WRITE, p, sizeof (*p));
}
